-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema pruebas
--

-- CREATE DATABASE IF NOT EXISTS pruebas;
-- USE pruebas;

--
-- Definition of table `sh_address`
--

DROP TABLE IF EXISTS `sh_address`;
CREATE TABLE `sh_address` (
  `id_sh_address` int(11) NOT NULL AUTO_INCREMENT,
  `sh_client_id` int(11) NOT NULL,
  `address` varchar(300) NOT NULL,
  PRIMARY KEY (`id_sh_address`),
  KEY `fk_sh_address_sh_client_idx` (`sh_client_id`),
  CONSTRAINT `fk_sh_address_sh_client` FOREIGN KEY (`sh_client_id`) REFERENCES `sh_client` (`id_sh_client`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sh_address`
--

/*!40000 ALTER TABLE `sh_address` DISABLE KEYS */;
INSERT INTO `sh_address` (`id_sh_address`,`sh_client_id`,`address`) VALUES 
 (1,1,'Plaza de España, 1\r\nMadrid\r\nSpain'),
 (2,1,'Calle Gran Vía, 1\r\nMadrid\r\nSpain'),
 (4,1,'Plaza Mayor, 1\r\nMadrid\r\nEspaña'),
 (5,1,'Avda. Marqués de Corbera, 1\r\nMadrid\r\nEspaña');
/*!40000 ALTER TABLE `sh_address` ENABLE KEYS */;


--
-- Definition of table `sh_client`
--

DROP TABLE IF EXISTS `sh_client`;
CREATE TABLE `sh_client` (
  `id_sh_client` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(10) NOT NULL,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`id_sh_client`),
  UNIQUE KEY `code_UNIQUE` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sh_client`
--

/*!40000 ALTER TABLE `sh_client` DISABLE KEYS */;
INSERT INTO `sh_client` (`id_sh_client`,`code`,`name`) VALUES 
 (1,'00000002W','Juan Español');
/*!40000 ALTER TABLE `sh_client` ENABLE KEYS */;


--
-- Definition of table `sh_invoice`
--

DROP TABLE IF EXISTS `sh_invoice`;
CREATE TABLE `sh_invoice` (
  `id_sh_invoice` int(10) unsigned zerofill NOT NULL AUTO_INCREMENT,
  `reference` varchar(12) NOT NULL,
  `sh_client_id` int(11) NOT NULL,
  `clientCode` varchar(10) NOT NULL,
  `clientName` varchar(50) NOT NULL,
  `sh_address_id` int(11) NOT NULL,
  `shipDate` date DEFAULT NULL,
  PRIMARY KEY (`id_sh_invoice`),
  UNIQUE KEY `reference_UNIQUE` (`reference`),
  KEY `fk_sh_invoice_sh_address1_idx` (`sh_address_id`),
  KEY `fk_sh_invoice_sh_client1_idx` (`sh_client_id`),
  CONSTRAINT `fk_sh_invoice_sh_address1` FOREIGN KEY (`sh_address_id`) REFERENCES `sh_address` (`id_sh_address`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_sh_invoice_sh_client1` FOREIGN KEY (`sh_client_id`) REFERENCES `sh_client` (`id_sh_client`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sh_invoice`
--

/*!40000 ALTER TABLE `sh_invoice` DISABLE KEYS */;
INSERT INTO `sh_invoice` (`id_sh_invoice`,`reference`,`sh_client_id`,`clientCode`,`clientName`,`sh_address_id`,`shipDate`) VALUES 
 (0000000003,'1/2025',1,'00000002W','Juan Español',2,'2025-03-16'),
 (0000000004,'2/2025',1,'00000002W','Juan Español',4,'2025-03-16'),
 (0000000005,'3/2025',1,'00000002W','Juan Español',5,'2025-03-16');
/*!40000 ALTER TABLE `sh_invoice` ENABLE KEYS */;




/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
